//OHSAT GAMES MEGATILER TUTORIAL - TILE MOVEMENT (Part 1)- https://www.ohsat.com/tutorial/megatiler/megatiler-3/
//MEGATEAMWORK Makes the MEGADREAM Work 
//SGDK Version: 2.0 

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>
 
#define SPAWN_TILE 4    // value for player sprite for use in array
#define TILESIZE 8      // pixel value tile size
#define SOLID_TILE 1    // barrier tile
#define MAP_WIDTH 8     // tile width
#define MAP_HEIGHT 8    // tile height

// 4 is player sprite, 0 is grass tile, 1 is wall tile.
u8 level1[8][8] = {
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 1, 1, 0, 0, 0},
    {4, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0}
};

u8 x = 0;
u8 y = 0;
u8 t = 0;

// --- FIX: Forward declaration added ---
int getTileAt(u8 X, u8 Y);

typedef struct {
    u8 x;
    u8 y; 
} Point;

typedef enum { up, down, left, right, none } moveDirection;

typedef struct {
    Point pos;
    Point tilePos;
    int w; 
    int h;
    int health;
    bool moving;
    moveDirection dir;
    Sprite *sprite;
    char name[6];
} Entity;

Entity player = {{0, 0}, {0, 0}, 8, 8, 0, FALSE, none, NULL, "PLAYER"};

void loadLevel();
void movePlayer(moveDirection Direction);
void myJoyHandler(u16 joy, u16 changed, u16 state);

int main()
{   
    JOY_init();
    JOY_setEventHandler(&myJoyHandler);
    loadLevel();
   
    while(1)
    {
        SPR_update(); 
        SYS_doVBlankProcess();
    }

    return 0;
}

// --- FIXED TILE ACCESS ---
int getTileAt(u8 X, u8 Y)
{
    // Safer way: direct access
    return level1[Y][X];
}

void loadLevel()
{
    SPR_init();

    for (y = 0; y < MAP_HEIGHT; y++) {
        for (x = 0; x < MAP_WIDTH; x++) {
            t = level1[y][x];

            if (t == SPAWN_TILE)
            {
                player.tilePos.x = x;
                player.tilePos.y = y;

                player.pos.x = x * TILESIZE;
                player.pos.y = y * TILESIZE;

                player.sprite = SPR_addSprite(
                    &spr_player,
                    player.pos.x,
                    player.pos.y,
                    TILE_ATTR(PAL2, 0, FALSE, FALSE)
                );

                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
            }
            else {
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, t + 1), x, y);
            }
        }
    }

    VDP_loadTileSet(floortiles.tileset, 1, DMA);
    PAL_setPalette(PAL1, floortiles.palette->data, DMA);
    PAL_setPalette(PAL2, spr_player.palette->data, DMA);
}

void movePlayer(moveDirection Direction)
{
    if (!player.moving)
    {
        switch(Direction)
        {
            case up:
                if (player.tilePos.y > 0 &&
                    getTileAt(player.tilePos.x, player.tilePos.y - 1) != SOLID_TILE)
                {
                    player.tilePos.y--;
                    player.moving = TRUE;
                    player.dir = Direction;
                }
                break;

            case down:
                if (player.tilePos.y < MAP_HEIGHT - 1 &&
                    getTileAt(player.tilePos.x, player.tilePos.y + 1) != SOLID_TILE)
                {
                    player.tilePos.y++;
                    player.moving = TRUE;
                    player.dir = Direction;
                }
                break;

            case left:
                if (player.tilePos.x > 0 &&
                    getTileAt(player.tilePos.x - 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x--;
                    player.moving = TRUE;
                    player.dir = Direction;
                }
                break;

            case right:
                if (player.tilePos.x < MAP_WIDTH - 1 &&
                    getTileAt(player.tilePos.x + 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x++;
                    player.moving = TRUE;
                    player.dir = Direction;
                }
                break;

            default:
                break;
        }
    }
}

void myJoyHandler(u16 joy, u16 changed, u16 state)
{
    if (joy == JOY_1)
    {
        if (state & BUTTON_UP)
            movePlayer(up);
        else if (state & BUTTON_DOWN)
            movePlayer(down);
        else if (state & BUTTON_LEFT)
            movePlayer(left);
        else if (state & BUTTON_RIGHT)
            movePlayer(right);
    }
}


////////////////////NOTES////////////////////

/*

1. Create a place-holder function called movePlayer(moveDirection Direction){
    //Move the player
    }

2. Create another function called myJoyHandler(u16 joy, u16 changed, u16 state) to
house the controller inputs. 

You'll notice that in the code, the JoyHandler pulls from the movePlayer function. This function
references the enum moveDirection. Below is the full JoyHandler function for reference. 

void myJoyHandler(u16 joy, u16 changed, u16 state)
{
    if (joy == JOY_1)
    {
        if (state & BUTTON_UP)
        {
            movePlayer(up);
        }
        else if (state & BUTTON_DOWN)
        {
            movePlayer(down);
        }
        else if (state & BUTTON_LEFT)
        {
            movePlayer(left);
        }
        else if (state & BUTTON_RIGHT)
        {
            movePlayer(right);
        }
    }
}

3. Initialize the controller and inputs at the start of main()

It should look like this: 

...//
int main()
{   
    JOY_init();
    JOY_setEventHandler(&myJoyHandler);
    loadLevel();
   
    while(1)
...//

4. Revisit the movePlayer function to define movement using case statements 
& a boolean within an if() statement (OHSAT code) or use a not statment like I used.

My code:

void movePlayer(moveDirection Direction)
{
    if (!player.moving)
    
}

OHSAT code: 

void movePlayer(moveDirection Direction){
    if (player.moving == FALSE)
    {
        //Do movement things
    }

Here's the basic structure for the base statements based on the directions

switch( Direction ){
    case up:
        break;
    case down:
        break;
    case left:
        break;
    case right:
        break;
    default:
        break;


5. Using a helper function to determine if the tile the character is moving to is empty or not.

Note: I was initially having trouble with how Andrej/OHSAT was using the helper function
(likely my fault) but I was able to work around it. Comments for this helper function
are in the code above. 

OHSAT usage of helper function for reference. 

int getTileAt(u8 X, u8 Y)
{
    return *(&level1[0][0] + (Y * MAP_HEIGHT + X));
}

This function returns the tile value at a specific coordinate of our map. 
It starts at the address of the first item in the array, then moves down the rows and columns to the value we want. 
It’s a quick and handy way to check values in our level map.

6. Include a #define for the Solid tile
Note: It's helpful to use #define to reference items within an array. 

We currently have a reference to #define SOLID_TILE 1 and SPAWN_TILE 4 as
references to the level1 array. 

7. Use the helper function to check vertically for a SOLID_TILE within movePlayer() function
using an if() statement. 
Note: We'll need to do similar checks horizontally as well, hence the case statements. 

if(player.tilePos.y > 0 && getTileAt(player.tilePos.x, player.tilePos.y - 1) != SOLID_TILE){

}

As you’ll remember, the tilePos struct inside the player entity stores the x- and y-coordinate of the player in tiles. 
So, the first thing we check is whether the player is already at the top edge of our map, by checking if tilePos.y > 0. 
Without this check we could simply leave the map and the edge of the screen, which isn’t good.

The second condition grabs the tile above the player and checks if it is supposed to be solid. 
That’s pretty much it, really! It’s rather simple once you get the logic behind it. 
If there is a tile above the player, and if that tile is empty, the player can move up.

Since we're referencing upward movement, in terms of the code we should denote player.dir = Direction and in this instance we're 
going to made a case statement for the Direction up. 

We're going to use these conditions within a case statement for up to perform this check. 

Conditions:

player.tilePos.y -= 1;
player.moving = TRUE;
player.dir = Direction;

Adding them into a case statement

switch( Direction ){
    case up:
    {
        if(player.tilePos.y > 0 && getTileAt(player.tilePos.x,player.tilePos.y-1) != SOLID_TILE){
            player.tilePos.y -= 1;
            player.moving = TRUE;
            player.dir = Direction;
        }
        break;
    }

8. Expand the switch(Direction){} to include case statements for the other directions [down, right, left] 

The completed switch(Direction){} should look like this. 

void movePlayer(moveDirection Direction)
{
    if (!player.moving)
    {
        switch(Direction)
        {
            case up:
                if (player.tilePos.y > 0 &&
                    getTileAt(player.tilePos.x, player.tilePos.y - 1) != SOLID_TILE)
                {
                    player.tilePos.y--;
                    player.moving = TRUE;
                    player.dir = Direction;
                }
                break;

            case down:
                if (player.tilePos.y < MAP_HEIGHT - 1 &&
                    getTileAt(player.tilePos.x, player.tilePos.y + 1) != SOLID_TILE)
                {
                    player.tilePos.y++;
                    player.moving = TRUE;
                    player.dir = Direction;
                }
                break;

            case left:
                if (player.tilePos.x > 0 &&
                    getTileAt(player.tilePos.x - 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x--;
                    player.moving = TRUE;
                    player.dir = Direction;
                }
                break;

            case right:
                if (player.tilePos.x < MAP_WIDTH - 1 &&
                    getTileAt(player.tilePos.x + 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x++;
                    player.moving = TRUE;
                    player.dir = Direction;
                }
                break;

            default:
                break;
        }
    }
}

If may be helpful for you to add some comments near each case statement to describe 
what each case is attempting to accomplish but the long and short is to check above,
below, in front, or behind of the player tile (SPAWN_TILE) to see if it's a grass or 
solid tile. 

*/

/////////EXPERIMENTATION IDEAS///////////////

/*

1. In Error Handling section you'll see my mistake I made when writing this earlier. 
I moved a lot of stuff out of the loadLevel() function. At some point, I think we
should try reorganizing code to see if we can start making header/.c files. 

Note: To save on repeated asset sizes, I'm clearing out the Music and SFX folders. 
If you still want the assets they're in the MEGATILER 02 lesson. 

*/

///////////ERROR HANDLING////////////////////

/*

I was having some issues with the OHSAT code. Initially, trying to keep the level1 array
nested in the loadLevel() function was causing compiling issues because the lesson is
written to have the array be a global declared. 

I moved my array & the helper function above main() and still ran into an issue (see below). 

C:/SGDK/bin/mkdir.exe -p out/src/ C:/SGDK/bin/gcc.exe -DSGDK_GCC -m68000 -Wall -
Wextra -Wno-shift-negative-value -Wno-main -Wno-unused-parameter -fno-builtin -fms-extensions -Iinc -Isrc -Ires -IC:/SGDK/inc -IC:/SGDK/res 
-BC:/SGDK/bin -O3 -fuse-linker-plugin -fno-web -fno-gcse -fno-unit-at-a-time -fomit-frame-pointer 
-flto -MMD -c src/main.c -o out/src/main.o src/main.c: 
In function 'movePlayer': src/main.c:121:45: warning: implicit declaration of function 'getTileAt' [-Wimplicit-function-declaration] 
if (player.tilePos.y > 0 && getTileAt(player.tilePos.x,player.tilePos.y-1) != SOLID_TILE) 
^~~~~~~~~ At top level: src/main.c:76:5: warning: 'getTileAt' defined but not used [-Wunused-function] int getTileAt(u8 X, u8 Y) 
^~~~~~~~~ echo "out/res/resources.o out/src/main.o" > out/cmd_ C:/SGDK/bin/gcc.exe -m68000 
-BC:/SGDK/bin -n -T C:/SGDK/md.ld -nostdlib out/sega.o @out/cmd_ C:/SGDK/lib/libmd.a 
C:/SGDK/lib/libgcc.a -o out/rom.out -Wl,--gc-sections -flto C:\...\AppData\Local\Temp\ccDQT85J.ltrans0.ltrans.o: In function myJoyHandler': 
<artificial>:(.text+0x960): undefined reference to getTileAt' <artificial>:
(.text+0x9b0): undefined reference to getTileAt' <artificial>:(.text+0x9f6): undefined reference to getTileAt' 
<artificial>:(.text+0xa52): undefined reference to getTileAt' make: *** [out/rom.out] Error 1

If all of that looks like Greek the just know that I commented out the fix above. 
I needed a forward decleration i.e. I predeclared the int getTileAt(u8 X, u8 Y); then finished the function at the bottom. 

For anyone curious, this was how I had everything previously that resulted in the error. 

#define SPAWN_TILE 4 //value for player sprite for use in array 
#define TILESIZE 8 //pixel value tile size 
#define SOLID_TILE 1 //barrier tile 
#define MAP_WIDTH 8 //pixel value for tile width 
#define MAP_HEIGHT 8 //pixel value for tile height 

// 4 is player sprite, 0 is grass tile, 1 is wall tile. 

u8 level1[8][8] = { 
{0, 0, 0, 0, 0, 0, 0, 0}, 
{0, 0, 0, 0, 0, 0, 0, 0}, 
{0, 0, 0, 0, 1, 0, 0, 0}, 
{0, 0, 0, 1, 1, 0, 0, 0}, 
{4, 0, 0, 0, 1, 0, 0, 0}, 
{0, 0, 0, 0, 1, 0, 0, 0}, 
{0, 0, 0, 0, 1, 0, 0, 0}, 
{0, 0, 0, 0, 0, 0, 0, 0} }; 

u8 x = 0; 
u8 y = 0; 
u8 t = 0; 

int getTileAt(u8 X, u8 Y) 
{ 
return *(&level1[0][0] + (Y * MAP_HEIGHT + X));
 } 

 typedef struct { 
u8 x; 
u8 y; 
}Point; 

typedef enum {up,down,left,right,none} moveDirection; 

typedef struct { 
Point pos; 
Point tilePos; 
int w; 
int h; 
int health; 
bool moving; 
moveDirection dir; 
Sprite *sprite; 
char name[6];
 }Entity; 

 Entity player = {{0, 0}, {0, 0}, 8, 8, 0, FALSE, none, NULL, "PLAYER"}; void loadLevel(); void movePlayer(moveDirection Direction); 

 void myJoyHandler(u16 joy, u16 changed, u16 state);
*/